%% P

 clear all; close all; 
clc;
addpath ~/Dropbox/sparse-hd-book/utils/

plot_type = 'mean_std_log10';


f=@(x) 1./x;

plot_name1 = 'ELU $4\times 40$ DNN'; plot_name2 = 'ELU $10\times 100$ DNN'; plot_name3 = 'ReLU $4\times 40$ DNN';
plot_name4 = 'ReLU $10\times 100$ DNN'; plot_name5 = 'tanh $4\times 40$ DNN'; plot_name6 = 'tanh $10\times 100$ DNN';plot_name7 = ' rate $m^{-1}$'; 
x_label_string = '$m$ samples';
y_label_string = ' Average relative $L^2_\mu(\mathcal{X}; \widetilde{\mathcal{Y}})$ error';

format shortG
%%
%1
load          raw_NSB_p/raw_p_data_elu_d_4_NSB_aff_S3_.mat
AUX = all_data;
AUX(:,:,3) = all_data(:,:,4);
load          raw_NSB_p/raw_p_data_relu_d_4_NSB_aff_S3_.mat
AUX(:,:,4) = all_data(:,:,2);
AUX(:,:,5) = all_data(:,:,4);
load          raw_NSB_p/raw_p_data_tanh_d_4_NSB_aff_S3_.mat
AUX(:,:,6) = all_data(:,:,2);
AUX(:,:,7) = all_data(:,:,4);
all_data=AUX;
mean_data  = squeeze(mean(all_data,4));
figure('Name','Measured Data');
% should be (num_m, num_trials, num_plots)
all_data(:,:,8)= f(all_data(:,:,1));
hPlot = plot_book_style(mean_data(:,1), all_data(:,:,2:8), 'shaded', plot_type);
axis tight
title('Affine coeff. NSB $p \in \mathrm{L}^2(\Omega)$, $d=4$ ','interpreter','latex')
legend([hPlot], {plot_name1,plot_name2, plot_name3,plot_name4,plot_name5,plot_name6, plot_name7});
xlabel(x_label_string,'interpreter', 'latex');
ylabel(y_label_string,'interpreter', 'latex');
beautify_plot
chosen_figure=gcf;
set(chosen_figure,'PaperUnits','inches');
set(chosen_figure,'PaperPositionMode','auto');
set(chosen_figure,'PaperSize',[str2num(figure_property.Width) str2num(figure_property.Height)]); % Canvas Size
set(chosen_figure,'Units','inches');
hgexport(gcf,'NSB_p/NSB_S3_p_d4_.pdf',figure_property); %Set desired file name
saveas(gcf,'NSB_p/NSB_S3_p_d4_.fig')
 close all; 
%%
%2
load          raw_NSB_p/raw_p_data_elu_d_4_NSB_logKL_.mat
AUX = all_data;
AUX(:,:,3) = all_data(:,:,4);
load          raw_NSB_p/raw_p_data_relu_d_4_NSB_logKL_.mat
AUX(:,:,4) = all_data(:,:,2);
AUX(:,:,5) = all_data(:,:,4);
load          raw_NSB_p/raw_p_data_tanh_d_4_NSB_logKL_.mat
AUX(:,:,6) = all_data(:,:,2);
AUX(:,:,7) = all_data(:,:,4);
all_data=AUX;
mean_data  = squeeze(mean(all_data,4));
figure('Name','Measured Data');
% should be (num_m, num_trials, num_plots)
all_data(:,:,8)= f(all_data(:,:,1));
hPlot = plot_book_style(mean_data(:,1), all_data(:,:,2:8), 'shaded', plot_type);
axis tight
title('LogKL coeff. NSB $p \in \mathrm{L}^2(\Omega)$, $d=4$ ','interpreter','latex')
legend([hPlot], {plot_name1,plot_name2, plot_name3,plot_name4,plot_name5,plot_name6, plot_name7});
xlabel(x_label_string,'interpreter', 'latex');
ylabel(y_label_string,'interpreter', 'latex');
beautify_plot
chosen_figure=gcf;
set(chosen_figure,'PaperUnits','inches');
set(chosen_figure,'PaperPositionMode','auto');
set(chosen_figure,'PaperSize',[str2num(figure_property.Width) str2num(figure_property.Height)]); % Canvas Size
set(chosen_figure,'Units','inches');
hgexport(gcf,'NSB_p/NSB_logKL_p_d4_.pdf',figure_property); %Set desired file name
saveas(gcf,'NSB_p/NSB_logKL_p_d4_.fig')
 close all; 
%%
%3
load          raw_NSB_p/raw_p_data_elu_d_8_NSB_aff_S3_.mat
AUX = all_data;
AUX(:,:,3) = all_data(:,:,4);
load          raw_NSB_p/raw_p_data_relu_d_8_NSB_aff_S3_.mat
AUX(:,:,4) = all_data(:,:,2);
AUX(:,:,5) = all_data(:,:,4);
load          raw_NSB_p/raw_p_data_tanh_d_8_NSB_aff_S3_.mat
AUX(:,:,6) = all_data(:,:,2);
AUX(:,:,7) = all_data(:,:,4);
all_data=AUX;
mean_data  = squeeze(mean(all_data,4));
figure('Name','Measured Data');
% should be (num_m, num_trials, num_plots)
all_data(:,:,8)= f(all_data(:,:,1));
hPlot = plot_book_style(mean_data(:,1), all_data(:,:,2:8), 'shaded', plot_type);
axis tight
title('Affine coeff. NSB $p \in \mathrm{L}^2(\Omega)$, $d=8$ ','interpreter','latex')
legend([hPlot], {plot_name1,plot_name2, plot_name3,plot_name4,plot_name5,plot_name6, plot_name7});
xlabel(x_label_string,'interpreter', 'latex');
ylabel(y_label_string,'interpreter', 'latex');
beautify_plot
chosen_figure=gcf;
set(chosen_figure,'PaperUnits','inches');
set(chosen_figure,'PaperPositionMode','auto');
set(chosen_figure,'PaperSize',[str2num(figure_property.Width) str2num(figure_property.Height)]); % Canvas Size
set(chosen_figure,'Units','inches');
hgexport(gcf,'NSB_p/NSB_S3_p_d8_.pdf',figure_property); %Set desired file name
saveas(gcf,'NSB_p/NSB_S3_p_d8_.fig')
 close all; 
%%
%4
load          raw_NSB_p/raw_p_data_elu_d_8_NSB_logKL_.mat
AUX = all_data;
AUX(:,:,3) = all_data(:,:,4);
load          raw_NSB_p/raw_p_data_relu_d_8_NSB_logKL_.mat
AUX(:,:,4) = all_data(:,:,2);
AUX(:,:,5) = all_data(:,:,4);
load          raw_NSB_p/raw_p_data_tanh_d_8_NSB_logKL_.mat
AUX(:,:,6) = all_data(:,:,2);
AUX(:,:,7) = all_data(:,:,4);
all_data=AUX;
mean_data  = squeeze(mean(all_data,4));
figure('Name','Measured Data');
% should be (num_m, num_trials, num_plots)
all_data(:,:,8)= f(all_data(:,:,1));
hPlot = plot_book_style(mean_data(:,1), all_data(:,:,2:8), 'shaded', plot_type);
axis tight
title('LogKL coeff. NSB $p \in \mathrm{L}^2(\Omega)$, $d=8$ ','interpreter','latex')
legend([hPlot], {plot_name1,plot_name2, plot_name3,plot_name4,plot_name5,plot_name6, plot_name7});
xlabel(x_label_string,'interpreter', 'latex');
ylabel(y_label_string,'interpreter', 'latex');
beautify_plot
chosen_figure=gcf;
set(chosen_figure,'PaperUnits','inches');
set(chosen_figure,'PaperPositionMode','auto');
set(chosen_figure,'PaperSize',[str2num(figure_property.Width) str2num(figure_property.Height)]); % Canvas Size
set(chosen_figure,'Units','inches');
hgexport(gcf,'NSB_p/NSB_logKL_p_d8_.pdf',figure_property); %Set desired file name
saveas(gcf,'NSB_p/NSB_logKL_p_d8_.fig')
 close all; 
